// Ignut

#include <bits/stdc++.h>

using namespace std;
using ll = long long;

const int MAXANS = 1e9;

class Hlopok {
    public:
        int t;
        int x;
};

class Segment {
    public:
        int l;
        int r;
};

bool cmp(Segment a, Segment b) {
    return a.l < b.l || (a.l == b.l && a.r < b.r);
}

bool cmph(Hlopok a, Hlopok b) {
    return a.t < b.t;
}

void Renew(vector <Segment> &v) {
    sort(v.begin(), v.end(), cmp);
    vector <Segment> nw = {};
    int l = v[0].l, r = v[0].r;
    for (int i = 1; i < v.size(); i ++) {
        if (v[i].l <= r)
            r = max(r, v[i].r);
        else {
            nw.push_back({l, r});
            l = v[i].l;
            r = v[i].r;
        }
    }
    nw.push_back({l, r});
    v = nw;
}

void DeleteSegment(vector <Segment> &v, int l, int r) {
    vector <Segment> nw = {};
    for (int i = 0; i < v.size(); i ++) {
        if (l < v[i].l && r > v[i].r) {
            continue;
        }
        else if (l < v[i].l && r <= v[i].r) {
            nw.push_back({r, v[i].r});
            //nw[i - del].l = r;
        }
        else if (l >= v[i].l && r > v[i].r) {
            nw.push_back({v[i].l, l});
            ///nw[i - del].r = l;
        }
        else if (l >= v[i].l && l <= v[i].r && r >= v[i].l && r <= v[i].r) {
            nw.push_back({v[i].l, l});
            nw.push_back({r, v[i].r});
        }
    }

    v = nw;
    sort(v.begin(), v.end(), cmp);
}

void Print(vector <Segment> v) {
    for (int i = 0; i < v.size(); i ++)
        cout << '{' << v[i].l << ", " << v[i].r << "}, ";
    cout << "\n";
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

	int n;
    cin >> n;
    vector <Hlopok> h;
    h.resize(n);
    for (int i = 0; i < n; i ++) {
        cin >> h[i].t >> h[i].x;
        h[i].x *= 2;
    }
    sort(h.begin(), h.end(), cmph);
    
    int l = 0, r = MAXANS;
    while (l != r) {
        int m = (l + r + 1) / 2;
        //cout << l << ' ' << r << ' ' << m << "\n";
        vector <Segment> v = {{0, 0}};
        bool f = true;

        int time = 0;

        for (int i = 0; i < n; i ++) {
            for (int j = 0; j < v.size(); j ++) {
                v[j].l -= (h[i].t - time) * 2;
                v[j].r += (h[i].t - time) * 2; 
            }
            Renew(v);

            DeleteSegment(v, h[i].x - m, h[i].x + m);
            /*
            if (m == 10)
                Print(v);
                */
            if (v.empty()) {
                f = false;
                break;
            }

            time = h[i].t;
        }

        if (!f)
            r = m - 1;
        else
            l = m;
    }

    double ans = (l - 0.0) / 2;
    cout << ans << "\n";

    /*
    vector <Segment> t = {{0, 10}};
    DeleteSegment(t, 3, 7);
    for (int i = 0; i < t.size(); i ++)
        cout << t[i].l << ' ' << t[i].r << "\n";
    cout << "\n";
    */
}
